/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class ThornbowArcherEffect
extends OneShotEffect {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent();

    public ThornbowArcherEffect() {
        super(Outcome.LoseLife);
        this.staticText = "each opponent who doesn't control an Elf loses 1 life";
    }

    private ThornbowArcherEffect(ThornbowArcherEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThornbowArcherEffect copy() {
        return new ThornbowArcherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID opponentId : game.getOpponents(controller.getId())) {
                Player opponent = game.getPlayer(opponentId);
                if (opponent == null || game.getBattlefield().countAll((FilterPermanent)filter, opponentId, game) != 0) continue;
                opponent.loseLife(1, game, source, false);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.ELF.getPredicate());
    }
}

