/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.common.search.SearchTargetGraveyardHandLibraryForCardNameAndExileEffect;
import mage.cards.Card;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ThoughtHemorrhageEffect
extends SearchTargetGraveyardHandLibraryForCardNameAndExileEffect {
    static final String rule = "Target player reveals their hand. {this} deals 3 damage to that player for each card with the chosen name revealed this way. Search that player's graveyard, hand, and library for all cards with that name and exile them. Then that player shuffles";

    public ThoughtHemorrhageEffect() {
        super(false, "that player's", "all cards with that name");
        this.staticText = rule;
    }

    private ThoughtHemorrhageEffect(ThoughtHemorrhageEffect effect) {
        super((SearchTargetGraveyardHandLibraryForCardNameAndExileEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (sourceObject != null && controller != null && cardName != null && !cardName.isEmpty() && (targetPlayer = game.getPlayer(source.getFirstTarget())) != null) {
            targetPlayer.revealCards("hand of " + targetPlayer.getName(), targetPlayer.getHand(), game);
            int cardsFound = 0;
            for (Card card : targetPlayer.getHand().getCards(game)) {
                if (!CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
                ++cardsFound;
            }
            if (cardsFound > 0) {
                targetPlayer.damage(3 * cardsFound, source.getSourceId(), source, game);
            }
            return this.applySearchAndExile(game, source, cardName, source.getFirstTarget());
        }
        return false;
    }

    public ThoughtHemorrhageEffect copy() {
        return new ThoughtHemorrhageEffect(this);
    }
}

