/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.Card;
import mage.cards.t.ThoughtPrisonDamageEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ThoughtPrisonTriggeredAbility
extends TriggeredAbilityImpl {
    public ThoughtPrisonTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ThoughtPrisonDamageEffect(), false);
        this.setTriggerPhrase("Whenever a player casts a spell that shares a color or mana value with the exiled card, ");
    }

    private ThoughtPrisonTriggeredAbility(ThoughtPrisonTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ThoughtPrisonTriggeredAbility copy() {
        return new ThoughtPrisonTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int imprintedCmc;
        int cmc;
        Spell spell = (Spell)game.getObject(event.getTargetId());
        Permanent sourcePermanent = game.getPermanent(this.getSourceId());
        if (spell == null) {
            return false;
        }
        if (sourcePermanent == null) {
            sourcePermanent = (Permanent)game.getLastKnownInformation(event.getSourceId(), Zone.BATTLEFIELD);
        }
        if (sourcePermanent == null || sourcePermanent.getImprinted() == null || sourcePermanent.getImprinted().isEmpty()) {
            return false;
        }
        Card imprintedCard = game.getCard((UUID)sourcePermanent.getImprinted().get(0));
        if (imprintedCard == null || game.getState().getZone(imprintedCard.getId()) != Zone.EXILED) {
            return false;
        }
        ObjectColor spellColor = spell.getColor(game);
        ObjectColor imprintedColor = imprintedCard.getColor(game);
        boolean matches = false;
        if (spellColor.shares(imprintedColor)) {
            matches = true;
        }
        if ((cmc = spell.getManaValue()) == (imprintedCmc = imprintedCard.getManaValue())) {
            matches = true;
        }
        if (matches) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
        }
        return matches;
    }
}

