/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.common.SpellCastControllerTriggeredAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.cards.t.ThousandYearStormEffect;
import mage.cards.t.ThousandYearStormSpellsCastThatTurnValue;
import mage.cards.t.ThousandYearStormWatcher;
import mage.constants.SetTargetPointer;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;

class ThousandYearStormAbility
extends SpellCastControllerTriggeredAbility {
    private String stormCountInfo;

    public ThousandYearStormAbility() {
        super((Effect)new ThousandYearStormEffect(), StaticFilters.FILTER_SPELL_AN_INSTANT_OR_SORCERY, false, SetTargetPointer.SPELL);
        this.addHint((Hint)new ValueHint("You've cast instant and sorcery this turn", (DynamicValue)ThousandYearStormSpellsCastThatTurnValue.instance));
        this.stormCountInfo = null;
    }

    private ThousandYearStormAbility(ThousandYearStormAbility ability) {
        super((SpellCastControllerTriggeredAbility)ability);
        this.stormCountInfo = ability.stormCountInfo;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (super.checkTrigger(event, game)) {
            ThousandYearStormWatcher watcher = (ThousandYearStormWatcher)game.getState().getWatcher(ThousandYearStormWatcher.class);
            if (watcher == null) {
                return false;
            }
            UUID playerId = event.getPlayerId();
            List<MageObjectReference> spellsCast = watcher.getSpellsThisTurn(playerId);
            MageObject object = game.getObject(event.getTargetId());
            if (object == null || spellsCast == null) {
                return false;
            }
            int stormCount = 0;
            for (MageObjectReference mor : spellsCast) {
                ++stormCount;
                if (!mor.refersTo(object, game)) continue;
                break;
            }
            stormCount = Math.max(0, stormCount - 1);
            this.stormCountInfo = " (<b>storm count: " + stormCount + "</b>) ";
            for (Effect effect : this.getEffects()) {
                if (!(effect instanceof ThousandYearStormEffect)) continue;
                ((ThousandYearStormEffect)effect).setStormCount(stormCount);
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever you cast an instant or sorcery spell, copy it for each other instant and sorcery spell you've cast before it this turn" + (this.stormCountInfo != null ? this.stormCountInfo : "") + ". You may choose new targets for the copies.";
    }

    public ThousandYearStormAbility copy() {
        return new ThousandYearStormAbility(this);
    }
}

