/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ThrakkusTheButcherEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledCreaturePermanent(SubType.DRAGON);

    ThrakkusTheButcherEffect() {
        super(Outcome.Benefit);
        this.staticText = "double the power of each Dragon you control until end of turn";
    }

    private ThrakkusTheButcherEffect(ThrakkusTheButcherEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThrakkusTheButcherEffect copy() {
        return new ThrakkusTheButcherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            if (permanent.getPower().getValue() == 0) continue;
            game.addEffect(new BoostTargetEffect(permanent.getPower().getValue(), 0).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        return true;
    }
}

