/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ThranPortalAdditionalCostEffect
extends ContinuousEffectImpl {
    ThranPortalAdditionalCostEffect() {
        super(Duration.WhileOnBattlefield, Layer.RulesEffects, SubLayer.NA, Outcome.Benefit);
        this.staticText = "mana abilities of {this} cost an additional 1 life to activate";
    }

    private ThranPortalAdditionalCostEffect(ThranPortalAdditionalCostEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public ThranPortalAdditionalCostEffect copy() {
        return new ThranPortalAdditionalCostEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent thranPortal = game.getPermanent(source.getSourceId());
        if (thranPortal == null) {
            return false;
        }
        Abilities abilities = thranPortal.getAbilities(game);
        if (abilities.isEmpty()) {
            return false;
        }
        boolean result = false;
        for (Ability ability : abilities) {
            if (!ability.isManaAbility()) continue;
            ability.addCost((Cost)new PayLifeCost(1));
            result = true;
        }
        return result;
    }
}

