/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class ThranTomeEffect
extends OneShotEffect {
    ThranTomeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Reveal the top three cards of your library. Target opponent chooses one of those cards. Put that card into your graveyard, then draw two cards";
    }

    private ThranTomeEffect(ThranTomeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThranTomeEffect copy() {
        return new ThranTomeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card cardToGraveyard;
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null || controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, 3));
        controller.revealCards(source, (Cards)cards, game);
        if (cards.size() == 1) {
            cardToGraveyard = cards.getRandom(game);
        } else {
            TargetCardInLibrary target = new TargetCardInLibrary(1, new FilterCard());
            opponent.chooseTarget(this.outcome, (Cards)cards, (TargetCard)target, source, game);
            cardToGraveyard = game.getCard(target.getFirstTarget());
        }
        if (cardToGraveyard != null) {
            controller.moveCards(cardToGraveyard, Zone.GRAVEYARD, source, game);
            cards.remove(cardToGraveyard);
        }
        controller.drawCards(2, source, game);
        return true;
    }
}

