/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingCreature;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ThreeDogGalaxyNewsDJTokenEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterAttackingCreature();
    private final Permanent sacPermanent;

    ThreeDogGalaxyNewsDJTokenEffect(Permanent permanent) {
        super(Outcome.Benefit);
        this.sacPermanent = permanent != null ? permanent.copy() : null;
        this.staticText = "for each other attacking creature you control, create a token that's a copy of that Aura attached to that creature";
    }

    private ThreeDogGalaxyNewsDJTokenEffect(ThreeDogGalaxyNewsDJTokenEffect effect) {
        super((OneShotEffect)effect);
        this.sacPermanent = effect.sacPermanent != null ? effect.sacPermanent.copy() : null;
    }

    public ThreeDogGalaxyNewsDJTokenEffect copy() {
        return new ThreeDogGalaxyNewsDJTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (this.sacPermanent == null) {
            return false;
        }
        for (Permanent attacker : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            new CreateTokenCopyTargetEffect().setSavedPermanent(this.sacPermanent).setAttachedTo(attacker.getId()).apply(game, source);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

