/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ThunderOfUnityTriggeredAbility
extends DelayedTriggeredAbility {
    ThunderOfUnityTriggeredAbility() {
        super((Effect)new LoseLifeOpponentsEffect(1), Duration.EndOfTurn, false, false);
        this.addEffect((Effect)new GainLifeEffect(1).concatBy("and"));
        this.setTriggerPhrase("Whenever a creature you control enters this turn, ");
    }

    private ThunderOfUnityTriggeredAbility(ThunderOfUnityTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public ThunderOfUnityTriggeredAbility copy() {
        return new ThunderOfUnityTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
    }
}

