/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ThunderbladeChargeCastEffect
extends OneShotEffect {
    ThunderbladeChargeCastEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may cast it without paying its mana cost";
    }

    private ThunderbladeChargeCastEffect(ThunderbladeChargeCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThunderbladeChargeCastEffect copy() {
        return new ThunderbladeChargeCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card sourceCard = game.getCard(source.getSourceId());
        if (controller != null && sourceCard != null && Zone.GRAVEYARD == game.getState().getZone(sourceCard.getId())) {
            game.getState().setValue("PlayFromNotOwnHandZone" + sourceCard.getId(), (Object)Boolean.TRUE);
            boolean cardWasCast = controller.cast(controller.chooseAbilityForCast(sourceCard, game, true), game, true, new ApprovingObject(source, game));
            game.getState().setValue("PlayFromNotOwnHandZone" + sourceCard.getId(), null);
            return cardWasCast;
        }
        return false;
    }
}

