/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.CommanderCastFromCommandZoneValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class ThunderclapDrakeEffect
extends OneShotEffect {
    ThunderclapDrakeEffect() {
        super(Outcome.Copy);
        this.staticText = "copy it for each time you've cast your commander from the command zone this game. You may choose new targets for the copies";
    }

    private ThunderclapDrakeEffect(ThunderclapDrakeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThunderclapDrakeEffect copy() {
        return new ThunderclapDrakeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)this.getValue("spellCast");
        int count = CommanderCastFromCommandZoneValue.instance.calculate(game, source, (Effect)this);
        if (spell == null || player == null || count <= 0) {
            return false;
        }
        game.informPlayers(spell.getLogName() + " will be copied " + count + " time" + (count > 1 ? "s" : "") + CardUtil.getSourceLogName((Game)game, (Ability)source));
        spell.createCopyOnStack(game, source, source.getControllerId(), true, count);
        return true;
    }
}

