/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.ReturnFromGraveyardToBattlefieldTargetEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ThunderkinAwakenerEffect
extends OneShotEffect {
    ThunderkinAwakenerEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target Elemental creature card in your graveyard with toughness less than {this}'s toughness. Return that card to the battlefield tapped and attacking. Sacrifice it at the beginning of the next end step";
    }

    private ThunderkinAwakenerEffect(ThunderkinAwakenerEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThunderkinAwakenerEffect copy() {
        return new ThunderkinAwakenerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card creatureCard = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller != null && creatureCard != null) {
            ReturnFromGraveyardToBattlefieldTargetEffect effect = new ReturnFromGraveyardToBattlefieldTargetEffect(true, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creatureCard.getId()));
            effect.apply(game, source);
            Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent != null) {
                SacrificeTargetEffect sacrificeEffect = new SacrificeTargetEffect("Sacrifice " + permanent.getName(), source.getControllerId());
                sacrificeEffect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
                AtTheBeginOfNextEndStepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)sacrificeEffect);
                game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
                InfoEffect.addInfoToPermanent((Game)game, (Ability)source, (Permanent)permanent, (String)"<i><b>Warning</b>: It will be sacrificed at the beginning of the next end step<i>");
            }
            return true;
        }
        return false;
    }
}

