/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class ThunderwaveEffect
extends OneShotEffect {
    ThunderwaveEffect() {
        super(Outcome.Benefit);
        this.staticText = "you may choose a creature. {this} deals 3 damage to each creature not chosen this way";
    }

    private ThunderwaveEffect(ThunderwaveEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThunderwaveEffect copy() {
        return new ThunderwaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent(0, 1);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (permanent.getId().equals(target.getFirstTarget())) continue;
            permanent.damage(3, source, game);
        }
        return true;
    }
}

