/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ThwipEffect
extends OneShotEffect {
    ThwipEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's a Spider, you gain 2 life";
    }

    private ThwipEffect(ThwipEffect effect) {
        super((OneShotEffect)effect);
    }

    public ThwipEffect copy() {
        return new ThwipEffect(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) return false;
        if (!permanent.hasSubtype(SubType.SPIDER, game)) return false;
        if (!Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(player -> player.gainLife(2, game, source) > 0).isPresent()) return false;
        return true;
    }
}

