/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TideOfWarEffect
extends OneShotEffect {
    TideOfWarEffect() {
        super(Outcome.Benefit);
        this.staticText = "flip a coin. If you win the flip, each blocking creature is sacrificed by its controller. If you lose the flip, each blocked creature is sacrificed by its controller";
    }

    private TideOfWarEffect(TideOfWarEffect effect) {
        super((OneShotEffect)effect);
    }

    public TideOfWarEffect copy() {
        return new TideOfWarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            HashSet<UUID> toSacrifice = new HashSet<UUID>();
            if (controller.flipCoin(source, game, true)) {
                for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                    for (UUID blockerId : combatGroup.getBlockers()) {
                        toSacrifice.add(blockerId);
                    }
                }
            } else {
                for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                    if (combatGroup.getBlockers().isEmpty()) continue;
                    for (UUID attackerId : combatGroup.getAttackers()) {
                        toSacrifice.add(attackerId);
                    }
                }
            }
            for (UUID creatureId : toSacrifice) {
                Permanent creature = game.getPermanent(creatureId);
                if (creature == null) continue;
                creature.sacrifice(source, game);
                Player player = game.getPlayer(creature.getControllerId());
                if (player == null) continue;
                game.informPlayers(player.getLogName() + " sacrifices " + creature.getName());
            }
            return true;
        }
        return false;
    }
}

