/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterNonlandCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class TidehollowScullerExileEffect
extends OneShotEffect {
    TidehollowScullerExileEffect() {
        super(Outcome.Exile);
        this.staticText = "target opponent reveals their hand and you choose a nonland card from it. Exile that card";
    }

    private TidehollowScullerExileEffect(TidehollowScullerExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public TidehollowScullerExileEffect copy() {
        return new TidehollowScullerExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller != null && opponent != null) {
            Card card;
            opponent.revealCards("Tidehollow Sculler", opponent.getHand(), game);
            TargetCard target = new TargetCard(Zone.HAND, (FilterCard)new FilterNonlandCard("nonland card to exile"));
            if (controller.choose(Outcome.Exile, opponent.getHand(), target, source, game) && (card = opponent.getHand().get(target.getFirstTarget(), game)) != null) {
                controller.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC()), "Tidehollow Sculler");
            }
            return true;
        }
        return false;
    }
}

