/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class TimeWipeEffect
extends OneShotEffect {
    TimeWipeEffect() {
        super(Outcome.Benefit);
        this.staticText = "Return a creature you control to its owner's hand, then destroy all creatures.";
    }

    private TimeWipeEffect(TimeWipeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TimeWipeEffect copy() {
        return new TimeWipeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        if (player.choose(this.outcome, (Target)target, source, game) && (permanent = game.getPermanent(target.getFirstTarget())) != null) {
            player.moveCards((Card)permanent, Zone.HAND, source, game);
        }
        return new DestroyAllEffect((FilterPermanent)StaticFilters.FILTER_PERMANENT_A_CREATURE).apply(game, source);
    }
}

