/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.turn.AddExtraTurnTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TimesifterEffect
extends OneShotEffect {
    TimesifterEffect() {
        super(Outcome.ExtraTurn);
        this.staticText = "each player exiles the top card of their library. The player who exiled the card with the greatest mana value takes an extra turn after this one. If two or more players' cards are tied for greatest, the tied players repeat this process until the tie is broken";
    }

    private TimesifterEffect(TimesifterEffect effect) {
        super((OneShotEffect)effect);
    }

    public TimesifterEffect copy() {
        return new TimesifterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<UUID> playersWithHighestCMC;
        Object playersExiling = game.getState().getPlayersInRange(source.getControllerId(), game);
        do {
            int highestCMC = Integer.MIN_VALUE;
            playersWithHighestCMC = new ArrayList<UUID>();
            Iterator iterator = playersExiling.iterator();
            while (iterator.hasNext()) {
                Card card;
                UUID playerId = (UUID)iterator.next();
                Player player = game.getPlayer(playerId);
                if (player == null || (card = player.getLibrary().getFromTop(game)) == null) continue;
                int cardCMC = card.getManaValue();
                player.moveCardsToExile(card, source, game, true, null, "");
                if (cardCMC > highestCMC) {
                    highestCMC = cardCMC;
                    playersWithHighestCMC.clear();
                    playersWithHighestCMC.add(playerId);
                    continue;
                }
                if (cardCMC != highestCMC) continue;
                playersWithHighestCMC.add(playerId);
            }
        } while ((playersExiling = new ArrayList(playersWithHighestCMC)).size() > 1);
        Iterator iterator = playersExiling.iterator();
        while (iterator.hasNext()) {
            UUID playerId = (UUID)iterator.next();
            AddExtraTurnTargetEffect effect = new AddExtraTurnTargetEffect();
            effect.setTargetPointer((TargetPointer)new FixedTarget(playerId));
            effect.apply(game, source);
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            game.informPlayers(player.getLogName() + " will take an extra turn after this one.");
        }
        return true;
    }
}

