/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.cards.Card;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;

class TinybonesBaubleBurglarPlayEffect
extends AsThoughEffectImpl {
    TinybonesBaubleBurglarPlayEffect() {
        super(AsThoughEffectType.PLAY_FROM_NOT_OWN_HAND_ZONE, Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "During your turn, you may play cards you don't own with stash counters on them from exile";
    }

    private TinybonesBaubleBurglarPlayEffect(TinybonesBaubleBurglarPlayEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public TinybonesBaubleBurglarPlayEffect copy() {
        return new TinybonesBaubleBurglarPlayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Card card;
        if (affectedControllerId.equals(source.getControllerId()) && game.isActivePlayer(source.getControllerId()) && (card = game.getCard(objectId)) != null) {
            Card mainCard = card.getMainCard();
            return game.getState().getZone(mainCard.getId()).equals((Object)Zone.EXILED) && !mainCard.isOwnedBy(source.getControllerId()) && mainCard.getCounters(game).containsKey(CounterType.STASH);
        }
        return false;
    }
}

