/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.FoodToken;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;

class TirelessProvisionerEffect
extends OneShotEffect {
    TirelessProvisionerEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a Food token or a Treasure token";
    }

    private TirelessProvisionerEffect(TirelessProvisionerEffect effect) {
        super((OneShotEffect)effect);
    }

    public TirelessProvisionerEffect copy() {
        return new TirelessProvisionerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        FoodToken token = player.chooseUse(this.outcome, "Create a Food token or a Treasure token?", null, "Food", "Treasure", source, game) ? new FoodToken() : new TreasureToken();
        return token.putOntoBattlefield(1, game, source, source.getControllerId());
    }
}

