/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.costs.common.RevealTargetFromHandCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TitansPresenceEffect
extends OneShotEffect {
    TitansPresenceEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile target creature if its power is less than or equal to the revealed card's power";
    }

    private TitansPresenceEffect(TitansPresenceEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        RevealTargetFromHandCost cost = (RevealTargetFromHandCost)source.getCosts().get(0);
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        if (cost != null && creature != null && controller != null) {
            Card card;
            List revealedCards = cost.getRevealedCards();
            if (!revealedCards.isEmpty() && (card = (Card)revealedCards.iterator().next()) != null && card.getPower().getValue() >= creature.getPower().getValue()) {
                controller.moveCards((Card)creature, Zone.EXILED, source, game);
            }
            return true;
        }
        return false;
    }

    public TitansPresenceEffect copy() {
        return new TitansPresenceEffect(this);
    }
}

