/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TobiasBeckettEffect
extends OneShotEffect {
    TobiasBeckettEffect() {
        super(Outcome.Exile);
        this.staticText = "exile the top card of that player's library. You may cast cards exiled this way and spend mana as though it were mana of any type to cast that spell";
    }

    private TobiasBeckettEffect(TobiasBeckettEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent;
        Permanent bountyTriggered;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (bountyTriggered = game.getPermanent(this.getTargetPointer().getFirst(game, source))) != null && (opponent = game.getPlayer(bountyTriggered.getControllerId())) != null) {
            MageObject sourceObject = game.getObject(source);
            UUID exileId = CardUtil.getCardExileZoneId((Game)game, (Ability)source);
            Card card = opponent.getLibrary().getFromTop(game);
            if (card != null && sourceObject != null) {
                controller.moveCardToExileWithInfo(card, exileId, sourceObject.getIdName(), source, game, Zone.LIBRARY, true);
                if (card.getSpellAbility() != null) {
                    CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.Custom, (boolean)true);
                }
            }
            return true;
        }
        return false;
    }

    public TobiasBeckettEffect copy() {
        return new TobiasBeckettEffect(this);
    }
}

