/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Collection;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.ExileTargetForSourceEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DiscardedCardsEvent;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class ToluzCleverConductorTriggeredAbility
extends TriggeredAbilityImpl {
    ToluzCleverConductorTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ExileTargetForSourceEffect());
    }

    private ToluzCleverConductorTriggeredAbility(ToluzCleverConductorTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ToluzCleverConductorTriggeredAbility copy() {
        return new ToluzCleverConductorTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DISCARDED_CARDS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (!this.isControlledBy(event.getPlayerId())) {
            return false;
        }
        DiscardedCardsEvent dEvent = (DiscardedCardsEvent)event;
        CardsImpl cards = new CardsImpl((Collection)dEvent.getDiscardedCards());
        cards.retainZone(Zone.GRAVEYARD, game);
        this.getEffects().setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game));
        return true;
    }

    public String getRule() {
        return "Whenever you discard one or more cards, exile them from your graveyard.";
    }
}

