/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class TombBladeEffect
extends OneShotEffect {
    TombBladeEffect() {
        super(Outcome.Benefit);
        this.staticText = "that player loses life equal to the number of creatures they control unless they sacrifice a creature";
    }

    private TombBladeEffect(TombBladeEffect effect) {
        super((OneShotEffect)effect);
    }

    public TombBladeEffect copy() {
        return new TombBladeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null) {
            return false;
        }
        int creatureCount = game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game);
        SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE);
        if (cost.canPay(source, source, player.getId(), game) && player.chooseUse(this.outcome, "Sacrifice a creature?", "If you don't you lose " + creatureCount + " life", "Yes", "No", source, game) && cost.pay(source, game, source, player.getId(), true)) {
            return true;
        }
        return player.loseLife(creatureCount, game, source, false) > 0;
    }
}

