/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TomikDistinguishedAdvokistTargetEffect
extends ContinuousRuleModifyingEffectImpl {
    TomikDistinguishedAdvokistTargetEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "lands on the battlefield and land cards in graveyards can't be the targets of spells or abilities your opponents control";
    }

    private TomikDistinguishedAdvokistTargetEffect(TomikDistinguishedAdvokistTargetEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public TomikDistinguishedAdvokistTargetEffect copy() {
        return new TomikDistinguishedAdvokistTargetEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TARGET;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        UUID targetId = event.getTargetId();
        Zone zone = game.getState().getZone(targetId);
        if (zone != Zone.BATTLEFIELD && zone != Zone.GRAVEYARD) {
            return false;
        }
        Permanent targetCard = zone == Zone.BATTLEFIELD ? game.getPermanent(targetId) : game.getCard(targetId);
        Player player = game.getPlayer(source.getControllerId());
        return targetCard != null && player != null && targetCard.isLand(game) && player.hasOpponent(event.getPlayerId(), game);
    }
}

