/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TooGreedilyTooDeepEffect
extends OneShotEffect {
    TooGreedilyTooDeepEffect() {
        super(Outcome.Benefit);
        this.staticText = "put target creature card from a graveyard onto the battlefield under your control. That creature deals damage equal to its power to each other creature";
    }

    private TooGreedilyTooDeepEffect(TooGreedilyTooDeepEffect effect) {
        super((OneShotEffect)effect);
    }

    public TooGreedilyTooDeepEffect copy() {
        return new TooGreedilyTooDeepEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (controller == null || card == null || game.getState().getZone(card.getId()) != Zone.GRAVEYARD) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        game.processAction();
        Permanent returnedCreature = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (returnedCreature != null && returnedCreature.getPower().getValue() > 0) {
            for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                if (creature.getId().equals(returnedCreature.getId())) continue;
                creature.damage(returnedCreature.getPower().getValue(), returnedCreature.getId(), source, game, false, true);
            }
        }
        return true;
    }
}

