/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ToppleTheStatueEffect
extends OneShotEffect {
    ToppleTheStatueEffect() {
        super(Outcome.Benefit);
        this.staticText = "Tap target permanent. If it's an artifact, destroy it.<br>Draw a card.";
    }

    private ToppleTheStatueEffect(ToppleTheStatueEffect effect) {
        super((OneShotEffect)effect);
    }

    public ToppleTheStatueEffect copy() {
        return new ToppleTheStatueEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.tap(source, game);
        if (permanent.isArtifact(game)) {
            permanent.destroy(source, game, false);
        }
        return new DrawCardSourceControllerEffect(1).apply(game, source);
    }
}

