/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class TorbranThaneOfRedFellEffect
extends ReplacementEffectImpl {
    TorbranThaneOfRedFellEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a red source you control would deal damage to an opponent or a permanent an opponent controls, it deals that much damage plus 2 instead.";
    }

    private TorbranThaneOfRedFellEffect(TorbranThaneOfRedFellEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowInc((int)event.getAmount(), (int)2));
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PERMANENT: 
            case DAMAGE_PLAYER: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null || !controller.hasOpponent(TorbranThaneOfRedFellEffect.getControllerOrSelf(event.getTargetId(), game), game) || !source.isControlledBy(game.getControllerId(event.getSourceId()))) {
            return false;
        }
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        Object sourceObject = sourcePermanent == null ? game.getObject(event.getSourceId()) : sourcePermanent;
        return sourceObject != null && sourceObject.getColor(game).isRed() && event.getAmount() > 0;
    }

    private static UUID getControllerOrSelf(UUID id, Game game) {
        UUID outId = game.getControllerId(id);
        return outId == null ? id : outId;
    }

    public TorbranThaneOfRedFellEffect copy() {
        return new TorbranThaneOfRedFellEffect(this);
    }
}

