/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Iterator;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TormentedThoughtsDiscardEffect
extends OneShotEffect {
    TormentedThoughtsDiscardEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player discards a number of cards equal to the sacrificed creature's power";
    }

    private TormentedThoughtsDiscardEffect(TormentedThoughtsDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public TormentedThoughtsDiscardEffect copy() {
        return new TormentedThoughtsDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && targetPlayer != null) {
            int power = 0;
            for (Cost cost : source.getCosts()) {
                SacrificeTargetCost sacCost;
                Iterator iterator;
                if (!(cost instanceof SacrificeTargetCost) || !(iterator = (sacCost = (SacrificeTargetCost)cost).getPermanents().iterator()).hasNext()) continue;
                Permanent permanent = (Permanent)iterator.next();
                power = permanent.getPower().getValue();
                break;
            }
            if (power > 0) {
                targetPlayer.discard(power, false, false, source, game);
            }
            return true;
        }
        return false;
    }
}

