/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RemoveAllCountersSourceCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TortureChamberEffect2
extends OneShotEffect {
    public TortureChamberEffect2() {
        super(Outcome.Damage);
        this.staticText = "{this} deals damage to target creature equal to the number of pain counters removed this way";
    }

    private TortureChamberEffect2(TortureChamberEffect2 effect) {
        super((OneShotEffect)effect);
    }

    public TortureChamberEffect2 copy() {
        return new TortureChamberEffect2(this);
    }

    public boolean apply(Game game, Ability source) {
        int countersRemoved = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof RemoveAllCountersSourceCost)) continue;
            countersRemoved = ((RemoveAllCountersSourceCost)cost).getRemovedCounters();
        }
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null) {
            permanent.damage(countersRemoved, source.getSourceId(), source, game, false, true);
            return true;
        }
        return false;
    }
}

