/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.players.Player;

class TouchOfTheEternalEffect
extends OneShotEffect {
    TouchOfTheEternalEffect() {
        super(Outcome.Neutral);
        this.staticText = "count the number of permanents you control. Your life total becomes that number";
    }

    private TouchOfTheEternalEffect(TouchOfTheEternalEffect effect) {
        super((OneShotEffect)effect);
    }

    public TouchOfTheEternalEffect copy() {
        return new TouchOfTheEternalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterControlledPermanent filter = new FilterControlledPermanent();
        Player player = game.getPlayer(source.getControllerId());
        int permanentsInPlay = game.getBattlefield().countAll((FilterPermanent)filter, source.getControllerId(), game);
        if (player != null) {
            player.setLife(permanentsInPlay, game, source);
            return true;
        }
        return false;
    }
}

