/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.WitherAbility;
import mage.cards.t.TowerAboveTriggeredAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TowerAboveEffect
extends OneShotEffect {
    TowerAboveEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Until end of turn, target creature gets +4/+4 and gains trample, wither, and \"When this creature attacks, target creature blocks it this turn if able.\"";
    }

    private TowerAboveEffect(TowerAboveEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target == null) {
            return false;
        }
        BoostTargetEffect effect = new BoostTargetEffect(4, 4, Duration.EndOfTurn);
        GainAbilityTargetEffect effect2 = new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn);
        GainAbilityTargetEffect effect3 = new GainAbilityTargetEffect((Ability)WitherAbility.getInstance(), Duration.EndOfTurn);
        GainAbilityTargetEffect effect4 = new GainAbilityTargetEffect((Ability)new TowerAboveTriggeredAbility(), Duration.EndOfTurn);
        effect.setTargetPointer((TargetPointer)new FixedTarget(target.getId(), game));
        effect2.setTargetPointer((TargetPointer)new FixedTarget(target.getId(), game));
        effect3.setTargetPointer((TargetPointer)new FixedTarget(target.getId(), game));
        effect4.setTargetPointer((TargetPointer)new FixedTarget(target.getId(), game));
        effect4.setText("");
        game.addEffect((ContinuousEffect)effect, source);
        game.addEffect((ContinuousEffect)effect2, source);
        game.addEffect((ContinuousEffect)effect3, source);
        game.addEffect((ContinuousEffect)effect4, source);
        return true;
    }

    public TowerAboveEffect copy() {
        return new TowerAboveEffect(this);
    }
}

