/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class TradeSecretsEffect
extends OneShotEffect {
    TradeSecretsEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Target opponent draws two cards, then you draw up to four cards. That opponent may repeat this process as many times as they choose";
    }

    private TradeSecretsEffect(TradeSecretsEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        String message = "Do you want to draw two cards and allow the spellcaster to draw up to four cards again?";
        String message2 = "How many cards do you want to draw?";
        Player controller = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(source.getFirstTarget());
        if (controller != null && targetOpponent != null) {
            new DrawCardTargetEffect(2).apply(game, source);
            int amountOfCardsToDraw = controller.getAmount(0, 4, message2, source, game);
            new DrawCardSourceControllerEffect(amountOfCardsToDraw).apply(game, source);
            while (targetOpponent.chooseUse(Outcome.AIDontUseIt, message, source, game)) {
                new DrawCardTargetEffect(2).apply(game, source);
                amountOfCardsToDraw = controller.getAmount(0, 4, message2, source, game);
                new DrawCardSourceControllerEffect(amountOfCardsToDraw).apply(game, source);
            }
            return true;
        }
        return false;
    }

    public TradeSecretsEffect copy() {
        return new TradeSecretsEffect(this);
    }
}

