/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.costs.common.ReturnToHandChosenControlledPermanentCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetControlledPermanent;

class TragicLessonEffect
extends OneShotEffect {
    TragicLessonEffect() {
        super(Outcome.Discard);
        this.staticText = "Then discard a card unless you return a land you control to its owner's hand.";
    }

    private TragicLessonEffect(TragicLessonEffect effect) {
        super((OneShotEffect)effect);
    }

    public TragicLessonEffect copy() {
        return new TragicLessonEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ReturnToHandChosenControlledPermanentCost cost;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && controller.chooseUse(Outcome.Discard, "Return a land you control to its owner's hand?", source, game) && (cost = new ReturnToHandChosenControlledPermanentCost(new TargetControlledPermanent(StaticFilters.FILTER_CONTROLLED_PERMANENT_A_LAND))).canPay(source, source, controller.getId(), game) && cost.pay(source, game, source, controller.getId(), false, null)) {
            return true;
        }
        if (controller != null) {
            controller.discard(1, false, false, source, game);
            return true;
        }
        return false;
    }
}

