/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.BlockingOrBlockedWatcher;

class TrailblazersTorchEffect
extends OneShotEffect {
    TrailblazersTorchEffect() {
        super(Outcome.Benefit);
        this.staticText = "it deals 2 damage to each creature blocking it";
    }

    private TrailblazersTorchEffect(TrailblazersTorchEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrailblazersTorchEffect copy() {
        return new TrailblazersTorchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent attacker = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (attacker == null) {
            return false;
        }
        for (Permanent blocker : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (!BlockingOrBlockedWatcher.check((Permanent)attacker, (Permanent)blocker, (Game)game)) continue;
            blocker.damage(2, attacker.getId(), source, game);
        }
        return true;
    }
}

