/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TrainingDroneEffect
extends RestrictionEffect {
    TrainingDroneEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack or block unless it's equipped";
    }

    private TrainingDroneEffect(TrainingDroneEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            List attachments = permanent.getAttachments();
            for (UUID uuid : attachments) {
                Permanent attached = game.getPermanent(uuid);
                if (!attached.hasSubtype(SubType.EQUIPMENT, game)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public TrainingDroneEffect copy() {
        return new TrainingDroneEffect(this);
    }
}

