/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Library;
import mage.players.Player;

class TransmogrifyEffect
extends OneShotEffect {
    TransmogrifyEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "That creature's controller reveals cards from the top of their library until they reveal a creature card. That player puts that card onto the battlefield, then shuffles the rest into their library";
    }

    private TransmogrifyEffect(TransmogrifyEffect effect) {
        super((OneShotEffect)effect);
    }

    public TransmogrifyEffect copy() {
        return new TransmogrifyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent != null && (player = game.getPlayer(permanent.getControllerId())) != null) {
            Library library = player.getLibrary();
            if (library.hasCards()) {
                CardsImpl cards = new CardsImpl();
                Card toBattlefield = null;
                for (Card card : library.getCards(game)) {
                    cards.add(card);
                    if (!card.isCreature(game)) continue;
                    toBattlefield = card;
                    break;
                }
                if (toBattlefield != null) {
                    player.moveCards(toBattlefield, Zone.BATTLEFIELD, source, game);
                }
                player.revealCards(source, (Cards)cards, game);
                cards.remove(toBattlefield);
                if (!cards.isEmpty()) {
                    player.shuffleLibrary(source, game);
                }
            }
            return true;
        }
        return false;
    }
}

