/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.effects.SearchEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterArtifactCard;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetSacrifice;
import mage.util.ManaUtil;

class TransmuteArtifactEffect
extends SearchEffect {
    TransmuteArtifactEffect() {
        super(new TargetCardInLibrary((FilterCard)new FilterArtifactCard()), Outcome.PutCardInPlay);
        this.staticText = "Sacrifice an artifact. If you do, search your library for an artifact card. If that card's mana value is less than or equal to the sacrificed artifact's mana value, put it onto the battlefield. If it's greater, you may pay {X}, where X is the difference. If you do, put it onto the battlefield. If you don't, put it into its owner's graveyard. Then shuffle";
    }

    private TransmuteArtifactEffect(TransmuteArtifactEffect effect) {
        super((SearchEffect)effect);
    }

    public TransmuteArtifactEffect copy() {
        return new TransmuteArtifactEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int manaValue = 0;
        boolean sacrifice = false;
        TargetSacrifice targetArtifact = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_ARTIFACT);
        if (controller.choose(Outcome.Sacrifice, (Target)targetArtifact, source, game)) {
            Permanent permanent = game.getPermanent(targetArtifact.getFirstTarget());
            if (permanent != null) {
                manaValue = permanent.getManaValue();
                sacrifice = permanent.sacrifice(source, game);
            }
        } else {
            return true;
        }
        if (sacrifice && controller.searchLibrary(this.target, source, game)) {
            if (!this.target.getTargets().isEmpty()) {
                for (UUID cardId : this.target.getTargets()) {
                    Card card = controller.getLibrary().getCard(cardId, game);
                    if (card == null) continue;
                    if (card.getManaValue() <= manaValue) {
                        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                        continue;
                    }
                    ManaCost cost = ManaUtil.createManaCost((int)(card.getManaValue() - manaValue), (boolean)true);
                    boolean payed = false;
                    if (controller.chooseUse(Outcome.Benefit, "Do you want to pay " + cost.getText() + " to put it onto the battlefield?", source, game) && cost.pay(source, game, source, source.getControllerId(), false)) {
                        payed = true;
                    }
                    if (payed) {
                        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                        continue;
                    }
                    controller.moveCards(card, Zone.GRAVEYARD, source, game);
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        controller.shuffleLibrary(source, game);
        return false;
    }
}

