/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.t.TrapTheTrespassersVote;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TrapTheTrespassersEffect
extends OneShotEffect {
    TrapTheTrespassersEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player secretly votes for a creature you don't control, then those votes are revealed. For each creature with one or more votes, put that many stun counters on it, then tap it";
    }

    private TrapTheTrespassersEffect(TrapTheTrespassersEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrapTheTrespassersEffect copy() {
        return new TrapTheTrespassersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (!game.getBattlefield().contains((FilterPermanent)StaticFilters.FILTER_CREATURE_YOU_DONT_CONTROL, source, game, 1)) {
            return false;
        }
        TrapTheTrespassersVote vote = new TrapTheTrespassersVote(source, game);
        vote.doVotes(source, game);
        for (Map.Entry<Permanent, Integer> entry : vote.getVotesPerCreature(game).entrySet()) {
            entry.getKey().addCounters(CounterType.STUN.createInstance(entry.getValue().intValue()), source, game);
            entry.getKey().tap(source, game);
        }
        return true;
    }
}

