/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TreacherousPitDwellerEffect
extends ContinuousEffectImpl {
    TreacherousPitDwellerEffect() {
        super(Duration.Custom, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.GainControl);
        this.staticText = "target opponent gains control of {this}";
    }

    private TreacherousPitDwellerEffect(TreacherousPitDwellerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public TreacherousPitDwellerEffect copy() {
        return new TreacherousPitDwellerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Player targetOpponent = game.getPlayer(source.getFirstTarget());
        if (permanent != null && targetOpponent != null) {
            return permanent.changeControllerId(targetOpponent.getId(), game, source);
        }
        this.discard();
        return false;
    }
}

