/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBaseToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TreeOfRedemptionEffect
extends OneShotEffect {
    TreeOfRedemptionEffect() {
        super(Outcome.GainLife);
        this.staticText = "Exchange your life total with {this}'s toughness";
    }

    private TreeOfRedemptionEffect(TreeOfRedemptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent perm = game.getPermanent(source.getSourceId());
        if (perm == null || player == null || !player.isLifeTotalCanChange() || !perm.isCreature(game)) {
            return false;
        }
        int amount = perm.getToughness().getValue();
        int life = player.getLife();
        if (life == amount) {
            return false;
        }
        if (life < amount && !player.isCanGainLife()) {
            return false;
        }
        if (life > amount && !player.isCanLoseLife()) {
            return false;
        }
        player.setLife(amount, game, source);
        game.addEffect((ContinuousEffect)new SetBaseToughnessSourceEffect(life, Duration.Custom), source);
        return true;
    }

    public TreeOfRedemptionEffect copy() {
        return new TreeOfRedemptionEffect(this);
    }
}

