/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TrespassersCurseEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class TrespassersCurseTriggeredAbility
extends TriggeredAbilityImpl {
    public TrespassersCurseTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TrespassersCurseEffect(), false);
        this.setTriggerPhrase("Whenever a creature enters the battlefield under enchanted player's control, ");
    }

    private TrespassersCurseTriggeredAbility(TrespassersCurseTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent enchantment = game.getPermanent(this.sourceId);
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (enchantment != null && permanent != null && enchantment.getAttachedTo() != null && permanent.getControllerId().equals(enchantment.getAttachedTo()) && permanent.isCreature(game)) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(enchantment.getAttachedTo(), game));
            }
            return true;
        }
        return false;
    }

    public TrespassersCurseTriggeredAbility copy() {
        return new TrespassersCurseTriggeredAbility(this);
    }
}

