/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.HashSet;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TrialEffect
extends OneShotEffect {
    TrialEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Return all creatures blocking or blocked by target creature to their owner's hand";
    }

    private TrialEffect(TrialEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrialEffect copy() {
        return new TrialEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (controller != null && creature != null) {
            HashSet<Permanent> toHand = new HashSet<Permanent>();
            for (CombatGroup combatGroup : game.getCombat().getGroups()) {
                if (combatGroup.getBlockers().contains(creature.getId())) {
                    for (UUID attackerId : combatGroup.getAttackers()) {
                        Permanent attacker = game.getPermanent(attackerId);
                        if (attacker == null) continue;
                        toHand.add(attacker);
                    }
                    continue;
                }
                if (!combatGroup.getAttackers().contains(creature.getId())) continue;
                for (UUID blockerId : combatGroup.getBlockers()) {
                    Permanent blocker = game.getPermanent(blockerId);
                    if (blocker == null) continue;
                    toHand.add(blocker);
                }
            }
            controller.moveCards(toHand, Zone.HAND, source, game);
            return true;
        }
        return false;
    }
}

