/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class TripleTriadEffect
extends OneShotEffect {
    TripleTriadEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player exiles the top card of their library. Until end of turn, you may play the card you own exiled this way and each other card exiled this way with lesser mana value than it without paying their mana costs";
    }

    private TripleTriadEffect(TripleTriadEffect effect) {
        super((OneShotEffect)effect);
    }

    public TripleTriadEffect copy() {
        return new TripleTriadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) {
                return false;
            }
            Card card = player.getLibrary().getFromTop(game);
            if (card == null) continue;
            player.moveCards(card, Zone.EXILED, source, game);
            cards.add(card);
        }
        Card card = cards.getCards(game).stream().filter(c -> c.isOwnedBy(source.getControllerId())).findAny().orElse(null);
        if (card == null) {
            return true;
        }
        cards.removeIf(uuid -> game.getCard(uuid).getManaValue() >= card.getManaValue());
        cards.add(card);
        game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.EndOfTurn, true, false).setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game)), source);
        return true;
    }
}

