/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.t.TritonTacticsDelayedTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TritonTacticsUntapEffect
extends OneShotEffect {
    TritonTacticsUntapEffect() {
        super(Outcome.Untap);
        this.staticText = "untap those creatures. At this turn's next end of combat, tap each creature that was blocked by one of those creatures this turn and it doesn't untap during its controller's next untap step";
    }

    private TritonTacticsUntapEffect(TritonTacticsUntapEffect effect) {
        super((OneShotEffect)effect);
    }

    public TritonTacticsUntapEffect copy() {
        return new TritonTacticsUntapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List<Permanent> permanents = this.getTargetPointer().getTargets(game, source).stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        if (permanents.isEmpty()) {
            return false;
        }
        for (Permanent permanent : permanents) {
            permanent.untap(game);
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new TritonTacticsDelayedTriggeredAbility(permanents, game), source);
        return true;
    }
}

