/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TrostaniSelesnyasVoiceEffect
extends OneShotEffect {
    TrostaniSelesnyasVoiceEffect() {
        super(Outcome.GainLife);
        this.staticText = "you gain life equal to that creature's toughness";
    }

    private TrostaniSelesnyasVoiceEffect(TrostaniSelesnyasVoiceEffect effect) {
        super((OneShotEffect)effect);
    }

    public TrostaniSelesnyasVoiceEffect copy() {
        return new TrostaniSelesnyasVoiceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID creatureId = (UUID)this.getValue("lifeSource");
        Integer zoneChangeCounter = (Integer)this.getValue("zoneChangeCounter");
        Permanent creature = game.getPermanent(creatureId);
        if (creature == null || creature.getZoneChangeCounter(game) != zoneChangeCounter.intValue()) {
            creature = (Permanent)game.getLastKnownInformation(creatureId, Zone.BATTLEFIELD, zoneChangeCounter.intValue());
        }
        if (creature != null) {
            int amount = creature.getToughness().getValue();
            Player player = game.getPlayer(source.getControllerId());
            if (player != null) {
                player.gainLife(amount, game, source);
            }
            return true;
        }
        return false;
    }
}

