/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.Objects;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.t.TrostaniSelesnyasVoiceEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TrostaniSelesnyasVoiceTriggeredAbility
extends TriggeredAbilityImpl {
    public TrostaniSelesnyasVoiceTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new TrostaniSelesnyasVoiceEffect(), false);
        this.setTriggerPhrase("Whenever another creature you control enters, ");
    }

    private TrostaniSelesnyasVoiceTriggeredAbility(TrostaniSelesnyasVoiceTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getTargetId());
        if (permanent == null || !permanent.isCreature(game) || !permanent.isControlledBy(this.controllerId) || Objects.equals(event.getTargetId(), this.getSourceId())) {
            return false;
        }
        Effect effect = (Effect)this.getEffects().get(0);
        effect.setValue("lifeSource", (Object)event.getTargetId());
        effect.setValue("zoneChangeCounter", (Object)permanent.getZoneChangeCounter(game));
        return true;
    }

    public TrostaniSelesnyasVoiceTriggeredAbility copy() {
        return new TrostaniSelesnyasVoiceTriggeredAbility(this);
    }
}

