/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class TroveOfTemptationForceAttackEffect
extends RequirementEffect {
    TroveOfTemptationForceAttackEffect(Duration duration) {
        super(duration, true);
        this.staticText = "Each opponent must attack you or a planeswalker you control with at least one creature each combat if able";
    }

    private TroveOfTemptationForceAttackEffect(TroveOfTemptationForceAttackEffect effect) {
        super((RequirementEffect)effect);
    }

    public TroveOfTemptationForceAttackEffect copy() {
        return new TroveOfTemptationForceAttackEffect(this);
    }

    public boolean mustAttack(Game game) {
        return false;
    }

    public boolean mustBlock(Game game) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        return controller != null && controller.hasOpponent(game.getActivePlayerId(), game);
    }

    public UUID playerMustBeAttackedIfAble(Ability source, Game game) {
        return source.getControllerId();
    }
}

