/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetOpponent;

class TruthOrConsequencesEffect
extends OneShotEffect {
    TruthOrConsequencesEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player secretly votes for truth or consequences, then those votes are revealed. You draw cards equal to the number of truth votes. Then choose an opponent at random. {this} deals 3 damage to that player for each consequences vote";
    }

    private TruthOrConsequencesEffect(TruthOrConsequencesEffect effect) {
        super((OneShotEffect)effect);
    }

    public TruthOrConsequencesEffect copy() {
        return new TruthOrConsequencesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TwoChoiceVote vote = new TwoChoiceVote("Truth (draw card)", "Consequences (deal damage)", Outcome.DrawCard, true);
        vote.doVotes(source, game);
        player.drawCards(vote.getVoteCount((Object)true), source, game);
        TargetOpponent target = new TargetOpponent(true);
        target.setRandom(true);
        target.choose(this.outcome, source.getControllerId(), source.getSourceId(), source, game);
        Player opponent = game.getPlayer(target.getFirstTarget());
        return opponent == null || opponent.damage(3 * vote.getVoteCount((Object)false), source, game) > 0;
    }
}

