/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.t;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class TsabosWebPreventUntapEffect
extends ContinuousRuleModifyingEffectImpl {
    TsabosWebPreventUntapEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Each land with an activated ability that isn't a mana ability doesn't untap during its controller's untap step";
    }

    private TsabosWebPreventUntapEffect(TsabosWebPreventUntapEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public TsabosWebPreventUntapEffect copy() {
        return new TsabosWebPreventUntapEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanent;
        if (game.getTurnStepType() == PhaseStep.UNTAP && (permanent = game.getPermanent(event.getTargetId())) != null && permanent.isLand(game)) {
            for (Ability ability : permanent.getAbilities()) {
                if (!ability.isNonManaActivatedAbility()) continue;
                return true;
            }
        }
        return false;
    }
}

